/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexPointerBlock;
import hu.uw.pallergabor.dedexer.DexSignatureBlock;
import hu.uw.pallergabor.dedexer.DexStringIdsBlock;
import hu.uw.pallergabor.dedexer.DexTypeIdsBlock;
import java.io.IOException;

public class DexProtoIdsBlock
extends DexParser {
    private ProtoHolder[] protos;
    private DexPointerBlock dexPointerBlock = null;
    private DexStringIdsBlock dexStringIdsBlock = null;
    private DexTypeIdsBlock dexTypeIdsBlock = null;
    private DexSignatureBlock dexSignatureBlock = null;

    @Override
    public void parse() throws IOException {
        this.setDexOptimizationData(this.dexSignatureBlock.getDexOptimizationData());
        int protoSize = (int)this.dexPointerBlock.getProtoIdsSize();
        this.file.seek(this.dexPointerBlock.getProtoIdsOffset());
        this.protos = new ProtoHolder[protoSize];
        long[] parmOffsets = new long[protoSize];
        int i = 0;
        while (i < protoSize) {
            this.protos[i] = new ProtoHolder();
            long shortyIdx = this.read32Bit();
            this.protos[i].returnType = (int)this.read32Bit();
            parmOffsets[i] = this.readFileOffset();
            this.dump("proto[" + i + "]: short signature: " + this.dexStringIdsBlock.getString((int)shortyIdx) + "; return type: " + this.dexTypeIdsBlock.getType(this.protos[i].returnType) + "; parameter block offset: " + this.dumpLong(parmOffsets[i]));
            ++i;
        }
        this.setDumpOff();
        i = 0;
        while (i < protoSize) {
            if (parmOffsets[i] > 0L) {
                this.file.seek(parmOffsets[i]);
                int parmNo = (int)this.read32Bit();
                ProtoHolder protoHolder = this.protos[i];
                protoHolder.parameterTypes = new int[parmNo];
                int n = 0;
                while (n < parmNo) {
                    int parameterTypeIdx;
                    protoHolder.parameterTypes[n] = parameterTypeIdx = this.read16Bit();
                    ++n;
                }
            }
            this.dump("// proto[" + i + "]: " + this.getReturnValueType(i) + " proto( " + this.getParameterValueTypes(i) + " )");
            ++i;
        }
        this.setDumpOn();
    }

    public int getProtosSize() {
        return (int)this.dexPointerBlock.getProtoIdsSize();
    }

    public String getReturnValueType(int idx) {
        ProtoHolder protoHolder = this.protos[idx];
        return this.dexTypeIdsBlock.getType(protoHolder.returnType);
    }

    public String getParameterValueTypes(int idx) {
        ProtoHolder protoHolder = this.protos[idx];
        if (protoHolder.parameterTypes == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < protoHolder.parameterTypes.length) {
            b.append(this.dexTypeIdsBlock.getType(protoHolder.parameterTypes[i]));
            ++i;
        }
        return new String(b);
    }

    public void setDexPointerBlock(DexPointerBlock dexPointerBlock) {
        this.dexPointerBlock = dexPointerBlock;
    }

    public void setDexStringIdsBlock(DexStringIdsBlock dexStringIdsBlock) {
        this.dexStringIdsBlock = dexStringIdsBlock;
    }

    public void setDexTypeIdsBlock(DexTypeIdsBlock dexTypeIdsBlock) {
        this.dexTypeIdsBlock = dexTypeIdsBlock;
    }

    public void setDexSignatureBlock(DexSignatureBlock dexSignatureBlock) {
        this.dexSignatureBlock = dexSignatureBlock;
    }

    class ProtoHolder {
        public int returnType = -1;
        public int[] parameterTypes = null;

        ProtoHolder() {
        }
    }
}

