<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include(__DIR__ . '/includes/functions.php');
$static_url = dirname($_SERVER['SCRIPT_NAME']) . '/assets/';
include 'session_check.php';

// Configurações do arquivo 📁
$configFile = __DIR__ . '/api/config.json';
$configData = [
    'polling_enabled' => false,
    'poll_interval_ms' => 18000000, // 5 horas em ms
    'show_all_apps_button' => true
];

// Carrega configurações existentes 📤
if (file_exists($configFile)) {
    $configContent = file_get_contents($configFile);
    $configData = json_decode($configContent, true);
}

// Processamento do formulário 📝
$success_message = "";
$error_message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Atualizar configurações ⚙️
    $newConfig = [
        'polling_enabled' => isset($_POST['polling_enabled']) ? true : false,
        'poll_interval_ms' => (int)$_POST['poll_interval'] * 3600000, // Converter horas para ms
        'show_all_apps_button' => isset($_POST['show_all_apps_button']) ? true : false
    ];
    
    // Validar intervalo ⏳
    if ($newConfig['poll_interval_ms'] < 3600000) { // Menor que 1 hora
        $error_message = "⚠️ O intervalo mínimo é de 1 hora!";
    } else {
        // Salvar no arquivo JSON 💾
        if (file_put_contents($configFile, json_encode($newConfig, JSON_PRETTY_PRINT))) {
            $configData = $newConfig;
            $success_message = "✅ Configurações salvas com sucesso!";
        } else {
            $error_message = "❌ Erro ao salvar configurações. Verifique as permissões.";
        }
    }
}

// Converter ms para horas para exibição ⏱️
$currentIntervalHours = $configData['poll_interval_ms'] / 3600000;

$page_title = "⏰ Agendamento de Desinstalações";

$page_content = '<div class="container mt-5">
    <div class="card mb-5 mb-xl-12">
        <div class="card-body py-12">
            <div class="d-flex align-items-center mb-7">
                <span class="symbol symbol-50px me-5">
                    <span class="symbol-label bg-light-primary">
                        <i class="ki-outline ki-clock fs-2x text-primary"></i>
                    </span>
                </span>
                <div>
                    <h2 class="mb-1">⏰ Agendamento de Desinstalações</h2>
                    <p class="text-gray-600">Configure quando as mensagens de desinstalação aparecerão para os clientes</p>
                </div>
            </div>';

if (!empty($success_message)) {
    $page_content .= '<div class="alert alert-success d-flex align-items-center" role="alert">
        <i class="ki-outline ki-check-circle fs-2x text-success me-4"></i>
        <div class="d-flex flex-column">
            <h4 class="mb-1 text-success">Sucesso!</h4>
            <span>' . htmlspecialchars($success_message) . '</span>
        </div>
    </div>';
}

if (!empty($error_message)) {
    $page_content .= '<div class="alert alert-danger d-flex align-items-center" role="alert">
        <i class="ki-outline ki-cross-circle fs-2x text-danger me-4"></i>
        <div class="d-flex flex-column">
            <h4 class="mb-1 text-danger">Erro!</h4>
            <span>' . htmlspecialchars($error_message) . '</span>
        </div>
    </div>';
}

$page_content .= '<form method="POST" action="">
    <div class="row g-6 mb-10">
        <div class="col-xl-6">
            <div class="card card-flush h-md-100">
                <div class="card-header">
                    <h3 class="card-title">🔄 Desinstalação Automático</h3>
                </div>
                <div class="card-body pt-1">
                    <div class="d-flex flex-column">
                        <div class="form-check form-switch form-check-custom form-check-solid mb-5">
                            <input class="form-check-input" type="checkbox" 
                                id="polling_enabled" name="polling_enabled" 
                                ' . ($configData['polling_enabled'] ? 'checked' : '') . '>
                            <label class="form-check-label" for="polling_enabled">
                                Ativar Desinstalação Automático
                            </label>
                        </div>
                        <p class="text-gray-600 mb-0">
                            Quando ativado, o sistema verificará periodicamente por comandos de desinstalação.
                        </p>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-6">
            <div class="card card-flush h-md-100">
                <div class="card-header">
                    <h3 class="card-title">⏱️ Intervalo de Verificação</h3>
                </div>
                <div class="card-body pt-1">
                    <div class="mb-5">
                        <label for="poll_interval" class="form-label">Intervalo (horas):</label>
                        <input type="number" class="form-control" 
                            id="poll_interval" name="poll_interval" 
                            min="1" value="' . $currentIntervalHours . '" required>
                        <div class="text-muted mt-2">Intervalo atual: ' . $currentIntervalHours . ' horas (' . ($currentIntervalHours / 24) . ' dias)</div>
                    </div>
                    <p class="text-gray-600 mb-0">
                        Define com que frequência o sistema verifica por comandos de desinstalação.
                    </p>
                </div>
            </div>
        </div>
    </div>
    
   
    
    <div class="notice d-flex bg-light-warning rounded border-warning border border-dashed p-6 mb-10">
        <i class="ki-outline ki-information-5 fs-2x text-warning me-4"></i>
        <div class="d-flex flex-stack flex-grow-1">
            <div class="fw-semibold">
                <h4 class="text-gray-900 fw-bold">⚠️ Informações Importantes</h4>
                <div class="fs-6 text-gray-700">
                    <p><strong>Desinstalação Automático:</strong> Quando ativado, os dispositivos verificarão periodicamente por comandos de desinstalação.</p>
                    <p><strong>Intervalo:</strong> Configure com cuidado - intervalos muito curtos podem deixa o cliente chateado .</p>
                    <p class="mb-0"><strong>Botão de Aplicativos:</strong> Permite aos usuários visualizar todos apps instalados.</p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="d-flex justify-content-end">
        <button type="submit" class="btn btn-primary btn-lg">
            <i class="ki-outline ki-check fs-2 me-2"></i> 💾 Salvar Configurações
        </button>
    </div>
</form>

<div class="separator separator-dashed my-10"></div>

<div class="row">
    <div class="col-xl-12">
        <h4 class="mb-4">📋 Configuração Atual</h4>
        <div class="card card-flush">
            <div class="card-body p-0">
                <pre class="bg-light p-6 rounded">' . htmlspecialchars(json_encode($configData, JSON_PRETTY_PRINT)) . '</pre>
            </div>
        </div>
    </div>
</div>';

include 'includes/layout.php';
?>