<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

// 🌐 Obter a URL base dinamicamente
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
$host = $_SERVER['HTTP_HOST'];
$basePath = dirname($_SERVER['SCRIPT_NAME']);
$baseUrl = "$protocol://$host$basePath";

// 📂 Caminho do arquivo JSON de configuração
$jsonFile = __DIR__ . '/img/api.json';

// 🎛️ Processar mudança de modo se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['mode'])) {
    // Carregar configurações existentes
    $jsonData = file_exists($jsonFile) ? json_decode(file_get_contents($jsonFile), true) : [
        'background' => '',
        'mode' => 'manual'
    ];

    $response = ['success' => false, 'message' => ''];

    try {
        // 🔄 Alterar o background conforme o modo selecionado
        if ($_POST['mode'] === 'auto') {
            $jsonData['background'] = $baseUrl . '/api/webview.php';
            $jsonData['mode'] = 'auto';
            $message = "🎬 Modo Filmes Automáticos ativado!";
        } else {
            $jsonData['background'] = $baseUrl . '/img/fundo_max.png';
            $jsonData['mode'] = 'manual';
            $message = "🖼️ Modo Anúncios Manuais ativado!";
        }

        // 💾 Salvar o JSON atualizado
        if (file_put_contents($jsonFile, json_encode($jsonData, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES))) {
            $response['success'] = true;
            $response['message'] = $message;
        } else {
            throw new Exception('❌ Falha ao salvar configurações');
        }
    } catch (Exception $e) {
        $response['message'] = $e->getMessage();
    }

    // 📡 Retornar JSON para requisições AJAX
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// 📋 Ler configurações atuais
$currentSettings = file_exists($jsonFile) ? json_decode(file_get_contents($jsonFile), true) : [
    'background' => '',
    'mode' => 'manual'
];

$page_title = "⚙️ Configurações de Exibição";
$page_content = '
<div class="container mt-5">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h3 class="mb-0">⚙️ Configurações de Exibição</h3>
        </div>
        <div class="card-body">
            <div class="alert alert-info mb-4">
                <i class="fas fa-info-circle me-2"></i>
                Escolha entre exibir anúncios manuais (imagem estática) ou filmes automáticos (conteúdo dinâmico).
                Esta configuração será aplicada automaticamente no fundo do sistema.
            </div>
            
            <form id="modeForm" method="POST">
                <div class="row mb-4">
                    <div class="col-md-6 mb-3 mb-md-0">
                        <div class="card mode-card h-100'.($currentSettings['mode'] === 'manual' ? ' border-primary' : '').'">
                            <div class="card-body text-center">
                                <h4><i class="fas fa-image me-2"></i>🖼️ Anúncios Manuais</h4>
                                <p class="text-muted">Imagem estática personalizada</p>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="mode" id="manualMode" 
                                        value="manual" '.($currentSettings['mode'] === 'manual' ? 'checked' : '').'>
                                    <label class="form-check-label" for="manualMode">
                                        Selecionar este modo
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="card mode-card h-100'.($currentSettings['mode'] === 'auto' ? ' border-primary' : '').'">
                            <div class="card-body text-center">
                                <h4><i class="fas fa-film me-2"></i>🎬 Filmes Automáticos</h4>
                                <p class="text-muted">Conteúdo dinâmico automático</p>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="mode" id="autoMode" 
                                        value="auto" '.($currentSettings['mode'] === 'auto' ? 'checked' : '').'>
                                    <label class="form-check-label" for="autoMode">
                                        Selecionar este modo
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>💾 Salvar Configurações
                </button>
                <div id="statusMessage" class="mt-3"></div>
            </form>
            
            <div class="mt-5">
                <h5><i class="fas fa-cog me-2"></i>ℹ️ Configuração Atual</h5>
                <div class="alert alert-dark">
                    <p class="mb-2 text-white"><strong>🔘 Modo atual:</strong> '.($currentSettings['mode'] === 'auto' ? '🎬 Filmes Automáticos' : '🖼️ Anúncios Manuais').'</p>
                    <p class="mb-0 text-white"><strong>🌐 URL do background:</strong> <code class="bg-dark text-white">'.$currentSettings['background'].'</code></p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.mode-card {
    cursor: pointer;
    transition: all 0.3s;
    border: 1px solid #dee2e6;
}
.mode-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}
.mode-card.border-primary {
    border: 2px solid #0d6efd !important;
    background-color: rgba(13, 110, 253, 0.05);
}
.alert-dark {
    background-color: #343a40 !important;
}
.alert-dark strong {
    color: #fff !important;
}
</style>

<script>
// 🚀 Envio do formulário via AJAX
document.getElementById("modeForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const statusElement = document.getElementById("statusMessage");
    const submitBtn = this.querySelector("button[type=\'submit\']");
    
    // ⏳ Mostrar loading no botão
    submitBtn.disabled = true;
    submitBtn.innerHTML = \'<i class="fas fa-spinner fa-spin me-2"></i>⏳ Salvando...\';
    
    fetch("", {
        method: "POST",
        body: formData,
        headers: {
            "X-Requested-With": "XMLHttpRequest"
        }
    })
    .then(response => {
        if (!response.ok) throw new Error("🌐 Erro na rede");
        return response.json();
    })
    .then(data => {
        if (data.success) {
            statusElement.innerHTML = `
                <div class="alert alert-success d-flex align-items-center">
                    <i class="fas fa-check-circle me-2"></i>
                    <div>${data.message}</div>
                </div>
            `;
            
            // Atualizar a página após 2 segundos
            setTimeout(() => {
                location.reload();
            }, 2000);
        } else {
            statusElement.innerHTML = `
                <div class="alert alert-danger d-flex align-items-center">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <div>❌ ${data.message}</div>
                </div>
            `;
        }
    })
    .catch(error => {
        statusElement.innerHTML = `
            <div class="alert alert-danger d-flex align-items-center">
                <i class="fas fa-exclamation-circle me-2"></i>
                <div>❌ Erro: ${error.message}</div>
            </div>
        `;
    })
    .finally(() => {
        submitBtn.disabled = false;
        submitBtn.innerHTML = \'<i class="fas fa-save me-2"></i>💾 Salvar Configurações\';
    });
});

// 👆 Melhorar a usabilidade dos cards
document.querySelectorAll(".mode-card").forEach(card => {
    card.addEventListener("click", function() {
        const radio = this.querySelector("input[type=\'radio\']");
        radio.checked = true;
        
        // Atualizar visual dos cards
        document.querySelectorAll(".mode-card").forEach(c => {
            c.classList.remove("border-primary");
        });
        this.classList.add("border-primary");
    });
});
</script>
';

include 'includes/layout.php';
?>